<?php
define('OK', 0);
define('SERVER_ERROR', 1);
define('INVALID_USER_NAME', 2);
define('INVALID_USER_PASS', 3);
define('USER_NAME_ALREADY_EXISTS', 4);
define('EMPTY_FIELDS', 5);

$host = 'localhost';
$baza = 'testphp';
$uzytkownik = "php";
$haslo = "test";

function rejestruj($nazwa, $pass, $imie, $nazwisko, $email)
{
  //Umożliwienie odwołań do zmiennych globalnych.
  global $host, $baza, $uzytkownik, $haslo;

  //Sprawdzenie poprawności danych (długość).
  //Dla kodowania jednobajtowego
  //$userPassLength = strlen($pass);
  //Dla kodowania utf-8
  $userPassLength = strlen(utf8_decode($pass));

  if($userPassLength < 6 || $userPassLength > 40)
    return INVALID_USER_PASS;

  if($imie == "" || $nazwisko == "" || $email == "")
    return EMPTY_FIELDS;

  //Sprawdzenie poprawności danych (wyrażenia regularne).
  if(!preg_match("/^[a-zA-Z0-9_.]{3,20}$/", $nazwa)){
    return INVALID_USER_NAME;
  };
  //Tutaj ewentualne dalsze instrukcje weryfikujące dane.

  //Nazwiązanie połączenia z bazą danych.
  $db_obj = new mysqli($host, $uzytkownik, $haslo, $baza);
  if($db_obj->connect_errno){
    //echo 'Wystąpił błąd podczas próby połączenia z serwerem MySQL...';
    //echo $db_obj->connect_error;
    return SERVER_ERROR;
  }

  //Zabezpieczenie znaków specjalnych w parametrach.
  $nazwa = $db_obj->real_escape_string($nazwa);
  $imie = $db_obj->real_escape_string($imie);
  $nazwisko = $db_obj->real_escape_string($nazwisko);
  $email = $db_obj->real_escape_string($email);
  
  //Sprawdzenie, czy użytkownik o podanej nazwie istnieje w bazie.
  $query = "SELECT COUNT(*) FROM Users WHERE Nazwa='$nazwa' ";

  if(!$result = $db_obj->query($query)){
    //echo 'Wystąpił błąd: nieprawidłowe zapytanie...';
    $db_obj->close();
    return SERVER_ERROR;
  }

  if(!$row = $result->fetch_row()){
    //echo('Wystąpił błąd: nieprawidłowe wyniki zapytania...');
    $db_obj->close();
    return SERVER_ERROR;
  }
  else{
    //Użytkownik istnieje, nie można dodać nowego wpisu do bazy.
    if($row[0] > 0){
      $db_obj->close();
      return USER_NAME_ALREADY_EXISTS;
    }
  }
  
  //Dodanie nowego użytkownika.
  $pass = crypt($pass);
  
  $query = "INSERT INTO Users VALUES(";
  $query .= "NULL, '$nazwa', '$pass', '$imie', '$nazwisko', '$email')";

  if(!$result = $db_obj->query($query)){
    //echo('Wystąpił błąd: instrukcja INSERT...');
    $db_obj->close();
    return SERVER_ERROR;
  }

  //Pobranie liczby dodanych rekordów.
  $count = $db_obj->affected_rows;

  if($count <> 1){
    //Niewłaściwe wyniki zapytania.
    $db_obj->close();
    return SERVER_ERROR;
  }
  else{
    //Prawidłowe dodanie rekordu.
    $db_obj->close();
    return OK;
  }
}

session_start();

//Sprawdzenie czy użytkownik jest już zalogowany.
if(isset($_SESSION['zalogowany'])){
  header("Location: main.php");
}
//Sprawdzenie czy zostały przekazane wszystkie pola formularza.
else if(!isset($_POST["nazwa"]) || !isset($_POST["haslo"]) ||
        !isset($_POST["imie"]) || !isset($_POST["nazwisko"]) ||
        !isset($_POST["email"])){
  include "new_user_form.php";
}
else{

?>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>Rejestracja</title>
</head>
<body>
<h2>

<?php
  //Odczytanie danych z formularza.
  $nazwa = $_POST["nazwa"];
  $pass = $_POST["haslo"];
  $imie = $_POST["imie"];
  $nazwisko = $_POST["nazwisko"];
  $email = $_POST["email"];

  //Wywołanie funkcji rejestrującej nowego użytkownika.
  $val = rejestruj($nazwa, $pass, $imie, $nazwisko, $email);

  //Reakcja na wartość zwróconą przez funkcję.
  if($val == OK){
    echo "Rejestracja poprawna. Możesz się <a href='login.php'>zalogować</a>.";
  }
  else if($val == INVALID_USER_NAME){
    echo "Nazwa użytkownika musi mieć od 3 do 20 znaków i może zawierać ";
    echo "jedynie znaki alfabetu łacińskiego oraz cyfry i znaki podkreślenia.";
  }
  else if($val == INVALID_USER_PASS){
    echo "Hasło musi mieć od 6 do 40 znaków.";
  }
  else if($val == USER_NAME_ALREADY_EXISTS){
    echo "Użytkownik $nazwa jest już zarejestrowany.";
  }
  else if($val == EMPTY_FIELDS){
    echo "Proszę wypełnić wszystkie wymagane pola formularza.";
  }
  else{
    echo "Błąd serwera. Rejestracja nie powiodła się.";
  }
}
?>
</h2>
</body>
</html>
